/************************************************************************
 * \file: iap2_parameter_parsing.h
 *
 * \version: $ $
 *
 * This header file declares functions required for parsing the parameters sent by Apple Devices.
 *
 * \component: global definition file
 *
 * \author: Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
 *
 * \copyright: (c) 2010 - 2016 ADIT Corporation
 *
 * CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
 *          DO NOT CHANGE THE CODE MANUALLY
 ***********************************************************************/

#ifndef IAP2_PARAMETER_PARSING_H
#define IAP2_PARAMETER_PARSING_H

#ifdef __cplusplus
extern "C" {
#endif

#include "iap2_init.h"

/**
 * \addtogroup ParameterParsing
 * @{
 */

 /***************************************************************************//**
 * Parses AuthenticationFailedParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2AuthenticationFailedParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses AuthenticationSucceededParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2AuthenticationSucceededParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses RequestAuthenticationCertificateParameter from Apple Device.
 * 
 * \param theiAP2RequestAuthenticationCertificateParameter Structure in which the parsed RequestAuthenticationCertificateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the RequestAuthenticationCertificateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2RequestAuthenticationCertificateParameter(iAP2RequestAuthenticationCertificateParameter* theiAP2RequestAuthenticationCertificateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses RequestAuthenticationChallengeResponseParameter from Apple Device.
 * 
 * \param theiAP2RequestAuthenticationChallengeResponseParameter Structure in which the parsed RequestAuthenticationChallengeResponseParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the RequestAuthenticationChallengeResponseParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2RequestAuthenticationChallengeResponseParameter(iAP2RequestAuthenticationChallengeResponseParameter* theiAP2RequestAuthenticationChallengeResponseParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses IdentificationAcceptedParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2IdentificationAcceptedParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses IdentificationRejectedParameter from Apple Device.
 * 
 * \param theiAP2IdentificationRejectedParameter Structure in which the parsed IdentificationRejectedParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the IdentificationRejectedParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2IdentificationRejectedParameter(iAP2IdentificationRejectedParameter* theiAP2IdentificationRejectedParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StartIdentificationParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StartIdentificationParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses OOBBTPairingLinkKeyInformationParameter from Apple Device.
 * 
 * \param theiAP2OOBBTPairingLinkKeyInformationParameter Structure in which the parsed OOBBTPairingLinkKeyInformationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the OOBBTPairingLinkKeyInformationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2OOBBTPairingLinkKeyInformationParameter(iAP2OOBBTPairingLinkKeyInformationParameter* theiAP2OOBBTPairingLinkKeyInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StartOOBBTPairingParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StartOOBBTPairingParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses StopOOBBTPairingParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StopOOBBTPairingParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses RouteGuidanceManeuverUpdateParameter from Apple Device.
 * 
 * \param theiAP2RouteGuidanceManeuverUpdateParameter Structure in which the parsed RouteGuidanceManeuverUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the RouteGuidanceManeuverUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2RouteGuidanceManeuverUpdateParameter(iAP2RouteGuidanceManeuverUpdateParameter* theiAP2RouteGuidanceManeuverUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses RouteGuidanceUpdateParameter from Apple Device.
 * 
 * \param theiAP2RouteGuidanceUpdateParameter Structure in which the parsed RouteGuidanceUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the RouteGuidanceUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2RouteGuidanceUpdateParameter(iAP2RouteGuidanceUpdateParameter* theiAP2RouteGuidanceUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses AssistiveTouchInformationParameter from Apple Device.
 * 
 * \param theiAP2AssistiveTouchInformationParameter Structure in which the parsed AssistiveTouchInformationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the AssistiveTouchInformationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2AssistiveTouchInformationParameter(iAP2AssistiveTouchInformationParameter* theiAP2AssistiveTouchInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses BluetoothConnectionUpdateParameter from Apple Device.
 * 
 * \param theiAP2BluetoothConnectionUpdateParameter Structure in which the parsed BluetoothConnectionUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the BluetoothConnectionUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2BluetoothConnectionUpdateParameter(iAP2BluetoothConnectionUpdateParameter* theiAP2BluetoothConnectionUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses CallStateUpdateParameter from Apple Device.
 * 
 * \param theiAP2CallStateUpdateParameter Structure in which the parsed CallStateUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the CallStateUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2CallStateUpdateParameter(iAP2CallStateUpdateParameter* theiAP2CallStateUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses CommunicationsUpdateParameter from Apple Device.
 * 
 * \param theiAP2CommunicationsUpdateParameter Structure in which the parsed CommunicationsUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the CommunicationsUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2CommunicationsUpdateParameter(iAP2CommunicationsUpdateParameter* theiAP2CommunicationsUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses ListUpdateParameter from Apple Device.
 * 
 * \param theiAP2ListUpdateParameter Structure in which the parsed ListUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the ListUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2ListUpdateParameter(iAP2ListUpdateParameter* theiAP2ListUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses DeviceAuthenticationCertificateParameter from Apple Device.
 * 
 * \param theiAP2DeviceAuthenticationCertificateParameter Structure in which the parsed DeviceAuthenticationCertificateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the DeviceAuthenticationCertificateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2DeviceAuthenticationCertificateParameter(iAP2DeviceAuthenticationCertificateParameter* theiAP2DeviceAuthenticationCertificateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses DeviceAuthenticationResponseParameter from Apple Device.
 * 
 * \param theiAP2DeviceAuthenticationResponseParameter Structure in which the parsed DeviceAuthenticationResponseParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the DeviceAuthenticationResponseParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2DeviceAuthenticationResponseParameter(iAP2DeviceAuthenticationResponseParameter* theiAP2DeviceAuthenticationResponseParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses DeviceInformationUpdateParameter from Apple Device.
 * 
 * \param theiAP2DeviceInformationUpdateParameter Structure in which the parsed DeviceInformationUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the DeviceInformationUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2DeviceInformationUpdateParameter(iAP2DeviceInformationUpdateParameter* theiAP2DeviceInformationUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses DeviceLanguageUpdateParameter from Apple Device.
 * 
 * \param theiAP2DeviceLanguageUpdateParameter Structure in which the parsed DeviceLanguageUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the DeviceLanguageUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2DeviceLanguageUpdateParameter(iAP2DeviceLanguageUpdateParameter* theiAP2DeviceLanguageUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses DeviceTimeUpdateParameter from Apple Device.
 * 
 * \param theiAP2DeviceTimeUpdateParameter Structure in which the parsed DeviceTimeUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the DeviceTimeUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2DeviceTimeUpdateParameter(iAP2DeviceTimeUpdateParameter* theiAP2DeviceTimeUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses DeviceTransportIdentifierNotificationParameter from Apple Device.
 * 
 * \param theiAP2DeviceTransportIdentifierNotificationParameter Structure in which the parsed DeviceTransportIdentifierNotificationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the DeviceTransportIdentifierNotificationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2DeviceTransportIdentifierNotificationParameter(iAP2DeviceTransportIdentifierNotificationParameter* theiAP2DeviceTransportIdentifierNotificationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses DeviceUUIDUpdateParameter from Apple Device.
 * 
 * \param theiAP2DeviceUUIDUpdateParameter Structure in which the parsed DeviceUUIDUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the DeviceUUIDUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2DeviceUUIDUpdateParameter(iAP2DeviceUUIDUpdateParameter* theiAP2DeviceUUIDUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses WirelessCarPlayUpdateParameter from Apple Device.
 * 
 * \param theiAP2WirelessCarPlayUpdateParameter Structure in which the parsed WirelessCarPlayUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the WirelessCarPlayUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2WirelessCarPlayUpdateParameter(iAP2WirelessCarPlayUpdateParameter* theiAP2WirelessCarPlayUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StartExternalAccessoryProtocolSessionParameter from Apple Device.
 * 
 * \param theiAP2StartExternalAccessoryProtocolSessionParameter Structure in which the parsed StartExternalAccessoryProtocolSessionParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the StartExternalAccessoryProtocolSessionParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StartExternalAccessoryProtocolSessionParameter(iAP2StartExternalAccessoryProtocolSessionParameter* theiAP2StartExternalAccessoryProtocolSessionParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StopExternalAccessoryProtocolSessionParameter from Apple Device.
 * 
 * \param theiAP2StopExternalAccessoryProtocolSessionParameter Structure in which the parsed StopExternalAccessoryProtocolSessionParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the StopExternalAccessoryProtocolSessionParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StopExternalAccessoryProtocolSessionParameter(iAP2StopExternalAccessoryProtocolSessionParameter* theiAP2StopExternalAccessoryProtocolSessionParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses DeviceHIDReportParameter from Apple Device.
 * 
 * \param theiAP2DeviceHIDReportParameter Structure in which the parsed DeviceHIDReportParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the DeviceHIDReportParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2DeviceHIDReportParameter(iAP2DeviceHIDReportParameter* theiAP2DeviceHIDReportParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StartNativeHIDParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StartNativeHIDParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses GPRMCDataStatusValuesNotificationParameter from Apple Device.
 * 
 * \param theiAP2GPRMCDataStatusValuesNotificationParameter Structure in which the parsed GPRMCDataStatusValuesNotificationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the GPRMCDataStatusValuesNotificationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2GPRMCDataStatusValuesNotificationParameter(iAP2GPRMCDataStatusValuesNotificationParameter* theiAP2GPRMCDataStatusValuesNotificationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StartLocationInformationParameter from Apple Device.
 * 
 * \param theiAP2StartLocationInformationParameter Structure in which the parsed StartLocationInformationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the StartLocationInformationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StartLocationInformationParameter(iAP2StartLocationInformationParameter* theiAP2StartLocationInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StopLocationInformationParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StopLocationInformationParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses MediaLibraryInformationParameter from Apple Device.
 * 
 * \param theiAP2MediaLibraryInformationParameter Structure in which the parsed MediaLibraryInformationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the MediaLibraryInformationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2MediaLibraryInformationParameter(iAP2MediaLibraryInformationParameter* theiAP2MediaLibraryInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses MediaLibraryUpdateParameter from Apple Device.
 * 
 * \param theiAP2MediaLibraryUpdateParameter Structure in which the parsed MediaLibraryUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the MediaLibraryUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2MediaLibraryUpdateParameter(iAP2MediaLibraryUpdateParameter* theiAP2MediaLibraryUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses NowPlayingUpdateParameter from Apple Device.
 * 
 * \param theiAP2NowPlayingUpdateParameter Structure in which the parsed NowPlayingUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the NowPlayingUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2NowPlayingUpdateParameter(iAP2NowPlayingUpdateParameter* theiAP2NowPlayingUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses PowerUpdateParameter from Apple Device.
 * 
 * \param theiAP2PowerUpdateParameter Structure in which the parsed PowerUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the PowerUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2PowerUpdateParameter(iAP2PowerUpdateParameter* theiAP2PowerUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses TelephonyCallStateInformationParameter from Apple Device.
 * 
 * \param theiAP2TelephonyCallStateInformationParameter Structure in which the parsed TelephonyCallStateInformationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the TelephonyCallStateInformationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2TelephonyCallStateInformationParameter(iAP2TelephonyCallStateInformationParameter* theiAP2TelephonyCallStateInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses TelephonyUpdateParameter from Apple Device.
 * 
 * \param theiAP2TelephonyUpdateParameter Structure in which the parsed TelephonyUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the TelephonyUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2TelephonyUpdateParameter(iAP2TelephonyUpdateParameter* theiAP2TelephonyUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses USBDeviceModeAudioInformationParameter from Apple Device.
 * 
 * \param theiAP2USBDeviceModeAudioInformationParameter Structure in which the parsed USBDeviceModeAudioInformationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the USBDeviceModeAudioInformationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2USBDeviceModeAudioInformationParameter(iAP2USBDeviceModeAudioInformationParameter* theiAP2USBDeviceModeAudioInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StartVehicleStatusUpdatesParameter from Apple Device.
 * 
 * \param theiAP2StartVehicleStatusUpdatesParameter Structure in which the parsed StartVehicleStatusUpdatesParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the StartVehicleStatusUpdatesParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StartVehicleStatusUpdatesParameter(iAP2StartVehicleStatusUpdatesParameter* theiAP2StartVehicleStatusUpdatesParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses StopVehicleStatusUpdatesParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2StopVehicleStatusUpdatesParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses VoiceOverCursorUpdateParameter from Apple Device.
 * 
 * \param theiAP2VoiceOverCursorUpdateParameter Structure in which the parsed VoiceOverCursorUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the VoiceOverCursorUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2VoiceOverCursorUpdateParameter(iAP2VoiceOverCursorUpdateParameter* theiAP2VoiceOverCursorUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses VoiceOverUpdateParameter from Apple Device.
 * 
 * \param theiAP2VoiceOverUpdateParameter Structure in which the parsed VoiceOverUpdateParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the VoiceOverUpdateParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2VoiceOverUpdateParameter(iAP2VoiceOverUpdateParameter* theiAP2VoiceOverUpdateParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses RequestAccessoryWiFiConfigurationInformationParameter from Apple Device.
 * 
* \param msgLength  Size of the Control Session Message received from Apple Device.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2RequestAccessoryWiFiConfigurationInformationParameter(U16 msgLength);

 /***************************************************************************//**
 * Parses WiFiInformationParameter from Apple Device.
 * 
 * \param theiAP2WiFiInformationParameter Structure in which the parsed WiFiInformationParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the WiFiInformationParameter Parameter has to be parsed.
 * \param msgLength  Size of the Control Session Message received from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2WiFiInformationParameter(iAP2WiFiInformationParameter* theiAP2WiFiInformationParameter, U8* p_SourceBuffer, U16 msgLength, const U8* iAP2BufferPool);

 /***************************************************************************//**
 * Parses BluetoothComponentProfiles from Apple Device.
 * 
 * \param theiAP2BluetoothComponentProfiles Structure in which the parsed BluetoothComponentProfiles has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the BluetoothComponentProfiles Sub-Parameter has to be parsed.
 * \param parameterLength  Size of the Parameter received for BluetoothComponentProfiles Message from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * \param iAP2BufferPool_WrPtr  Buffer pool write pointer, pointing to the free location where the Sub-Parameter data can be stored.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2BluetoothComponentProfiles(iAP2BluetoothComponentProfiles* theiAP2BluetoothComponentProfiles, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr);

 /***************************************************************************//**
 * Parses FavoritesList from Apple Device.
 * 
 * \param theiAP2FavoritesList Structure in which the parsed FavoritesList has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the FavoritesList Sub-Parameter has to be parsed.
 * \param parameterLength  Size of the Parameter received for FavoritesList Message from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * \param iAP2BufferPool_WrPtr  Buffer pool write pointer, pointing to the free location where the Sub-Parameter data can be stored.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2FavoritesList(iAP2FavoritesList* theiAP2FavoritesList, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr);

 /***************************************************************************//**
 * Parses MediaItem from Apple Device.
 * 
 * \param theiAP2MediaItem Structure in which the parsed MediaItem has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the MediaItem Sub-Parameter has to be parsed.
 * \param parameterLength  Size of the Parameter received for MediaItem Message from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * \param iAP2BufferPool_WrPtr  Buffer pool write pointer, pointing to the free location where the Sub-Parameter data can be stored.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2MediaItem(iAP2MediaItem* theiAP2MediaItem, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr);

 /***************************************************************************//**
 * Parses MediaLibraryInformationSubParameter from Apple Device.
 * 
 * \param theiAP2MediaLibraryInformationSubParameter Structure in which the parsed MediaLibraryInformationSubParameter has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the MediaLibraryInformationSubParameter Sub-Parameter has to be parsed.
 * \param parameterLength  Size of the Parameter received for MediaLibraryInformationSubParameter Message from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * \param iAP2BufferPool_WrPtr  Buffer pool write pointer, pointing to the free location where the Sub-Parameter data can be stored.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2MediaLibraryInformationSubParameter(iAP2MediaLibraryInformationSubParameter* theiAP2MediaLibraryInformationSubParameter, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr);

 /***************************************************************************//**
 * Parses MediaPlayList from Apple Device.
 * 
 * \param theiAP2MediaPlayList Structure in which the parsed MediaPlayList has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the MediaPlayList Sub-Parameter has to be parsed.
 * \param parameterLength  Size of the Parameter received for MediaPlayList Message from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * \param iAP2BufferPool_WrPtr  Buffer pool write pointer, pointing to the free location where the Sub-Parameter data can be stored.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2MediaPlayList(iAP2MediaPlayList* theiAP2MediaPlayList, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr);

 /***************************************************************************//**
 * Parses PlaybackAttributes from Apple Device.
 * 
 * \param theiAP2PlaybackAttributes Structure in which the parsed PlaybackAttributes has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the PlaybackAttributes Sub-Parameter has to be parsed.
 * \param parameterLength  Size of the Parameter received for PlaybackAttributes Message from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * \param iAP2BufferPool_WrPtr  Buffer pool write pointer, pointing to the free location where the Sub-Parameter data can be stored.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2PlaybackAttributes(iAP2PlaybackAttributes* theiAP2PlaybackAttributes, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr);

 /***************************************************************************//**
 * Parses RecentsList from Apple Device.
 * 
 * \param theiAP2RecentsList Structure in which the parsed RecentsList has to be stored.
 * \param p_SourceBuffer  Source Buffer from which the RecentsList Sub-Parameter has to be parsed.
 * \param parameterLength  Size of the Parameter received for RecentsList Message from Apple Device.
 * \param iAP2BufferPool  Base location of the Buffer Pool.
 * \param iAP2BufferPool_WrPtr  Buffer pool write pointer, pointing to the free location where the Sub-Parameter data can be stored.
 * 
 * \return IAP2_OK  On Successful completion of Parsing the message.
 * \return IAP2_INVALID_INPUT_PARAMETER When the input pointer is NULL.
 * \return IAP2_INVALID_PARAMETER_LENGTH When the Parameter Header Length is invalid.
 * \return IAP2_INVALID_PARAMETER_COUNT When the Parameter Count does not meet the criteria as mentioned in the Specification.
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2ParseiAP2RecentsList(iAP2RecentsList* theiAP2RecentsList, U8* p_SourceBuffer, U16 parameterLength, const U8* iAP2BufferPool, U8** iAP2BufferPool_WrPtr);

/** @} */

#ifdef __cplusplus
}
#endif

#endif
